<?php $__env->startSection('title', 'Emitir NF-e'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>Manter CT-e</h1>
</section>

<!-- Main content -->
<section class="content">

  <div class="row">
    <div class="col-md-12">
      <?php $__env->startComponent('components.widget'); ?>
      
      <input type="hidden" id="id" value="<?php echo e($cte->id, false); ?>" name="">
      <div class="col-md-12">
        <h4>Número CT-e: <strong><?php echo e($cte->cte_numero, false); ?></strong></h4>
        <h4>Natureza de Operação: <strong><?php echo e($cte->natureza->natureza, false); ?></strong></h4>
        <h4>Remetente: <strong><?php echo e($cte->remetente->cpf_cnpj, false); ?></strong></h4>
        <h4>Destinatário: <strong><?php echo e($cte->destinatario->name, false); ?></strong></h4>
        <h4>Tomador: <strong><?php echo e($cte->getTomador(), false); ?></strong></h4>
        <h4>Produto predominante: <strong><?php echo e($cte->produto_predominante, false); ?></strong></h4>
        <h4>Data precisa de entrega: <strong><?php echo e(\Carbon\Carbon::parse($cte->data_previsata_entrega)->format('d/m/Y'), false); ?></strong></h4>
        <h4>Estado: <strong><?php echo e($cte->estado, false); ?></strong></h4>
        <h4>Chave: <strong><?php echo e($cte->chave, false); ?></strong></h4>
      </div>

      <input type="hidden" id="cte_numero" value="<?php echo e($cte->cte_numero, false); ?>" name="">
      
      <div class="clearfix"></div>


      <div class="col-md-12">
        <a class="btn btn-lg btn-primary" target="_blank" href="/cte/imprimir/<?php echo e($cte->id, false); ?>" id="submit_user_button">Imprimir</a>
        <a class="btn btn-lg btn-info" target="_blank" href="/cte/baixarXml/<?php echo e($cte->id, false); ?>" id="submit_user_button">Baixar XML</a>

        <a class="btn btn-lg btn-question" style="background: #673ab7; color: #fff" id="consultar">
        Consultar</a>
        
        <?php if($cte->estado != 'CANCELADO'): ?>
        <a class="btn btn-lg btn-danger" id="cancelar">Cancelar CT-e</a>
        <!-- <a class="btn btn-lg btn-warning" id="corrigir">Corrigir CT-e</a> -->
        <?php endif; ?>


        <?php if($cte->sequencia_cce > 0): ?>
        <a class="btn btn-lg btn-question" style="background: #90caf9; color: #fff" target="_blank" href="/cte/imprimirCorrecao/<?php echo e($cte->id, false); ?>" id="submit_user_button">Imprimir Correção</a>
        <?php endif; ?>

        <?php if($cte->estado == 'CANCELADO'): ?>
        <a class="btn btn-lg btn-question" style="background: #d84315; color: #fff" target="_blank" href="/cte/imprimirCancelamento/<?php echo e($cte->id, false); ?>" id="submit_user_button">Imprimir Cancelamento</a>
        <?php endif; ?>
      </div>
      
      <?php echo $__env->renderComponent(); ?>
    </div>

  </div>

  

  <input type="hidden" id="token" value="<?php echo e(csrf_token(), false); ?>" name="">
  <input type="hidden" id="id" value="<?php echo e($cte->id, false); ?>" name="">

  <br>
  <div class="row" id="action" style="display: none">
    <div class="col-md-12">
      <?php $__env->startComponent('components.widget'); ?>
      <div class="info-box-content">
        <div class="col-md-4 col-md-offset-4">

          <span class="info-box-number total_purchase">
            <strong id="acao"></strong>
            <i class="fas fa-spinner fa-pulse fa-spin fa-fw margin-bottom"></i></span>
          </div>
        </div>
        <?php echo $__env->renderComponent(); ?>

      </div>
    </div>

    <?php $__env->stopSection(); ?>



    <?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
      // swal("Good job!", "You clicked the button!", "success");
      var path = window.location.protocol + '//' + window.location.host

      $('#cancelar').click(() => {
        let cte_numero = $('#cte_numero').val();
        swal({
          text: 'Cancelamento de CT-e '+cte_numero+'.',
          content: "input",
          button: {
            text: "Cancelar!",
            closeModal: false,
            type: 'error'
          },
          confirmButtonColor: "#DD6B55",
        })
        .then(v => {
          if (!v) swal("Erro!", "Informe um motivo para Cancelamento!", "error");
          else{
            let token = $('#token').val();
            let id = $('#id').val();
            $.ajax
            ({
              type: 'POST',
              data: {
                id: id,
                _token: token,
                justificativa: v
              },
              url: path + '/cte/cancelar',
              dataType: 'json',
              success: function(e){
                console.log(e)

                swal("sucesso", e.retEvento.infEvento.xMotivo, "success")
                .then(() => {
                  window.open(path + '/cte/imprimirCancelamento/'+id)
                  location.reload()
                });

              }, error: function(e){
                console.log(e)
                console.log(e.responseJSON.data.infEvento.xMotivo)

                swal("Erro ao cancelar", e.responseJSON.data.infEvento.xMotivo, "error");

              }

            })
          }         


        })
        
        .catch(err => {
          if (err) {
            swal("Erro", "Algo não ocorreu bem!", "error");
          } else {
            swal.stopLoading();
            swal.close();
          }
        });
      })

      $('#corrigir').click(() => {
        let cte_numero = $('#cte_numero').val();
        swal({
          text: 'Carta de correção para CT-e '+cte_numero+'.',
          content: "input",
          button: {
            text: "Corrigir!",
            closeModal: false,
            type: 'error'
          },
          confirmButtonColor: "#DD6B55",
        })
        .then(v => {
          if (!v) swal("Erro!", "Informe a correção!", "error");
          else{
            let token = $('#token').val();
            let id = $('#id').val();
            $.ajax
            ({
              type: 'POST',
              data: {
                id: id,
                _token: token,
                justificativa: v
              },
              url: path + '/cte/corrigir',
              dataType: 'json',
              success: function(e){
                console.log(e)

                swal("sucesso", e.retEvento.infEvento.xMotivo, "success")
                .then(() => {
                  window.open(path + '/cte/imprimirCorrecao/'+id)
                  location.reload()
                });
                

              }, error: function(e){
                console.log(e)
                console.log(e.responseJSON.data.retEvento.infEvento.xMotivo)

                swal("Erro ao corrigir", e.responseJSON.data.retEvento.infEvento.xMotivo, "error");

              }

            })
          }         


        })
        
        .catch(err => {
          if (err) {
            swal("Erro", "Algo não ocorreu bem!", "error");
          } else {
            swal.stopLoading();
            swal.close();
          }
        });
      })

      $('#consultar').click(() => {

        let token = $('#token').val();
        let id = $('#id').val();

        $.ajax
        ({
          type: 'POST',
          data: {
            id: id,
            _token: token
          },
          url: path + '/cte/consultar',
          dataType: 'json',
          success: function(e){
            console.log(e)

            swal("sucesso", "Resultado: " + e.protCTe.infProt.xMotivo + " - Chave: " + e.protCTe.infProt.chCTe, "success")
            .then(() => {
            });


          }, error: function(e){
            console.log(e)
            swal("Erro ao consultar", e.responseJSON, "error");

          }

        })
      })


    </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/Projetos/laravel/ultimate/resources/views/cte/ver.blade.php ENDPATH**/ ?>