<?php $__env->startSection('title', __('purchase.add_purchase')); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->


<!-- Main content -->
<section class="content">

	<?php echo Form::open(['url' => '/devolucao/save', 'method' => 'post', 'id' => 'add_purchase_form', 'files' => true ]); ?>

	<?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>

	<input type="hidden" value="<?php echo e(json_encode($contact), false); ?>" name="contact">
	<input type="hidden" value="<?php echo e(json_encode($itens), false); ?>" name="itens" id="itens">
	<input type="hidden" value="<?php echo e(json_encode($dadosNf), false); ?>" name="dadosNf">

	<div class="row">
		<div class="col-sm-12">
			<div class="form-group">
				<h3 class="box-title">Fornecedor</h3>
				<?php if($dadosNf['novoFornecedor']): ?>
				<p class="text-danger">*Este é um novo fornecedor, será cadastrado se finalizar a compra!</p>
				<?php endif; ?>
				<div class="row">
					<div class="col-sm-6">

						<span>Nome: <strong><?php echo e($contact['name'], false); ?></strong></span><br>
						<span>CNPJ/CPF: <strong><?php echo e($contact['cpf_cnpj'], false); ?></strong></span><br>
						<span>IE/RG: <strong><?php echo e($contact['ie_rg'], false); ?></strong></span>
					</div>

					<div class="col-sm-6">

						<span>Rua: <strong><?php echo e($contact['rua'], false); ?>, <?php echo e($contact['numero'], false); ?></strong></span><br>
						<span>Bairro: <strong><?php echo e($contact['bairro'], false); ?></strong></span><br>
						<span>Cidade: <strong><?php echo e($cidade->nome, false); ?> (<?php echo e($cidade->uf, false); ?>)</strong></span>

					</div>
				</div>
			</div>
		</div>

		<div class="col-sm-12">
			<div class="form-group">
				<h3 class="box-title">Dados do Documento</h3>

				<div class="row">
					<div class="col-sm-12">

						<span>Chave: <strong><?php echo e($dadosNf['chave'], false); ?></strong></span><br>
						<span>Valor: <strong><?php echo e($dadosNf['vProd'], false); ?></strong></span><br>
						<span>Número: <strong><?php echo e($dadosNf['nNf'], false); ?></strong></span><br>
						<span>Valor do frete: <strong><?php echo e($dadosNf['vFrete'], false); ?></strong></span><br>
						<span>Valor de desconto: <strong><?php echo e($dadosNf['vDesc'], false); ?></strong></span><br>
					</div>

				</div>
			</div>
		</div>

		<div class="col-sm-12">
			<div class="form-group">
				<h3 class="box-title">Produtos</h3>


				<div class="">
					
					<!-- Inicio tabela -->
					<div class="nav-tabs-custom">


						<div class="tab-content">
							<div class="tab-pane active" id="product_list_tab">
								<br><br>
								<div class="table-responsive">
									<div id="product_table_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
										<div class="row margin-bottom-20 text-center">
											<table class="table table-bordered table-striped ajax_view hide-footer dataTable no-footer" id="product_table" role="grid" aria-describedby="product_table_info" style="width: 1300px;">
												<thead>
													<tr role="row">
														
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 200px;" aria-label="Produto">Produto</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Código</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">NCM</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">CFOP</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Quantidade</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Valor Unit.</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 100px;" aria-label="Produto">Cod. Barras</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Unidade</th>
														<th class="sorting_disabled" rowspan="1" colspan="1" style="width: 80px;" aria-label="Produto">Ações</th>
													</tr>
												</thead>

												<tbody>

													<?php $__currentLoopData = $itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

													<tr id="tr_<?php echo e($i['codigo'], false); ?>">
														<td style="width: 200px;"><?php echo e($i['xProd'], false); ?></td>
														<td style="width: 80px;"><?php echo e($i['codigo'], false); ?></td>
														<td style="width: 80px;"><?php echo e($i['NCM'], false); ?></td>
														<td style="width: 80px;"><?php echo e($i['CFOP'], false); ?></td>
														<td style="width: 80px;"><?php echo e($i['qCom'], false); ?></td>
														<td style="width: 80px;"><?php echo e($i['vUnCom'], false); ?></td>
														<td style="width: 100px;"><?php echo e($i['codBarras'], false); ?></td>
														<td style="width: 100px;"><?php echo e($i['uCom'], false); ?></td>
														<td style="width: 100px;"><a onclick="removeItem('<?php echo e($i['codigo'], false); ?>')">Remove Item</a></td>

													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													
												</tbody>
											</table>
										</div>

									</div>


								</div>
							</div>
						</div>
					</div>

					<!-- fim tabela -->
				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">

				<div class="form-group">

					<div class="col-sm-4">
						<div class="form-group">
							<?php echo Form::label('natureza_id', 'Natureza de Operação para devolução'. ':*'); ?>

							<?php echo Form::select('natureza_id', $naturezas, null, ['id' => 'natureza_id', 'class' => 'form-control select2', 'required', 'placeholder' => __('messages.please_select')]);; ?>

						</div>
					</div>

					<div class="col-sm-5">
						<div class="form-group">
							<?php echo Form::label('motivo', 'Motivo'. ':*'); ?>

							<?php echo Form::text('motivo', null, ['class' => 'form-control', 'required',
							'placeholder' => 'Motivo']);; ?>

						</div>
					</div>

					<div class="col-sm-3">
						<div class="form-group">
							<?php echo Form::label('observacao', 'Observação'. ':'); ?>

							<?php echo Form::text('observacao', null, ['class' => 'form-control',
							'placeholder' => 'Observação']);; ?>

						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-sm-12">
				<button type="submit" class="btn btn-primary pull-right btn-flat">Salvar Devolução</button>
			</div>
		</div>


	</div>

	<?php echo $__env->renderComponent(); ?>
	<?php echo Form::close(); ?>



</section>

<?php $__env->startSection('javascript'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.11/jquery.mask.min.js"></script>
<script type="text/javascript">
	$('#perc_venda').mask('000.00')
	var ITENS = JSON.parse($('#itens').val());

	function removeItem(id){
		$('#tr_' + id).remove()
		let temp = [];
		ITENS.map((item) => {
			console.log(item.codigo[0])
			console.log(id)
			if(item.codigo[0] != id){
				temp.push(item)
			}
		})
		ITENS = temp;
		console.log(ITENS)
		$('#itens').val(JSON.stringify(ITENS))
	}
</script>

<?php $__env->stopSection(); ?>


<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/Projetos/laravel/ultimate/resources/views/devolucao/view_xml.blade.php ENDPATH**/ ?>